#version 330 core
out vec4 FragColor;

in vec3 ourColor;
in vec2 TexCoord;

uniform vec2 u_resolution;
uniform float u_time;

uniform sampler2D texture15;

float t;


float x = 0.;
float y = 0.;
float z = 0.;
float c = 0.;
int total = 100;
float PI = 3.14159265;
float HALF_PI = 1.57079633;
float r = 200.0;

vec3 color;
float plot(vec2 st, float pct) 
{
 return smoothstep( abs(cos(u_time / PI)), sqrt(sin(PI / pct + st.y)) 
 + ceil( st.y * PI / pct), pow( PI * -4.0, pct)) - smoothstep(st.y, pct * PI, st.x + abs(cos(st.y / u_time)));
}

void main()
{
	vec2 st = gl_FragCoord.xy/u_resolution.xy;

	if (u_time < 7)
	{
  st.x *= u_resolution.x/u_resolution.y;
  vec3 color = vec3(0.3);
  float d = 0.3;

  st = st *2.-1.;

  // Make the distance field
  d = length( abs(st)-.32 );
  d *= length((cos(st * 3.0)-.0,5.) );
  d *= length( max(abs(sin(st.y*u_time))-.27,0.) );

    color = vec3(vec2( smoothstep(.15 /sin(u_time),.35,d)- smoothstep(.5,.56,d)), 0.17);
	FragColor = texture(texture15, TexCoord) * vec4(color, 1.0);
	}
	
	if (u_time > 7)
	{
	vec3 color = vec3((sin(u_time) * 0.3)+0.2);
	FragColor = texture(texture15, TexCoord) * vec4(color, 1.0);
	}
}
